/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Implemnation of the "Device/Reset" dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2007-03-23  COOLDSTART/WARMSTART selection included

    2006-07-05  initial version

**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \file ResetDlg.cpp
///  Implemnation of the "Device/Reset" dialog
///////////////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cifXTest.h"
#include "ResetDlg.h"
#include "CifXTestDlg.h"

static struct RESET_MODEStag
{
  LPCTSTR       szMode;
  unsigned long ulMode;
} s_atResetModes[] =
{
  {_T("System Start"), CIFX_SYSTEMSTART},
  {_T("Channel Init"), CIFX_CHANNELINIT},
};

IMPLEMENT_DYNAMIC(CResetDlg, CBaseDialog)

/////////////////////////////////////////////////////////////////////////////
/// Default Constructor
///   \param pParent Parent Window
/////////////////////////////////////////////////////////////////////////////
CResetDlg::CResetDlg(CWnd* pParent /*=NULL*/)
  : CBaseDialog(CResetDlg::IDD, pParent, false)
  , m_ulTimeout(CIFX_TO_FIRMWARE_START)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CResetDlg::~CResetDlg()
{
}

/////////////////////////////////////////////////////////////////////////////
/// DDX/DDV support
///   \param pDX
/////////////////////////////////////////////////////////////////////////////
void CResetDlg::DoDataExchange(CDataExchange* pDX)
{
  CBaseDialog::DoDataExchange(pDX);
  DDX_Control(pDX, IDC_CB_RESET, m_cResetModeCtrl);
}


BEGIN_MESSAGE_MAP(CResetDlg, CBaseDialog)
  ON_CBN_SELCHANGE(IDC_CB_RESET, OnCbnSelchangeCbReset)
  ON_EN_KILLFOCUS(IDC_EDT_TIMEOUT, OnEnKillfocusEdtTimeout)
  ON_BN_CLICKED(IDC_BTN_RESET, OnBnClickedBtnReset)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
/// First Time dialog intialization. Fill Combobox control with reset modes
///   \return TRUE
/////////////////////////////////////////////////////////////////////////////
BOOL CResetDlg::OnInitDialog()
{
  CBaseDialog::OnInitDialog();

  SetDlgItemInt(IDC_EDT_TIMEOUT, m_ulTimeout, FALSE);

  return TRUE;  // return TRUE unless you set the focus to a control
  // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
/// Reset Mode selection changed event
/////////////////////////////////////////////////////////////////////////////
void CResetDlg::OnCbnSelchangeCbReset()
{
  int iCurSel = m_cResetModeCtrl.GetCurSel();
  ASSERT(-1 != iCurSel);

  m_ulResetMode = (unsigned long)m_cResetModeCtrl.GetItemData(iCurSel);
}

/////////////////////////////////////////////////////////////////////////////
/// Timeout editing end event
/////////////////////////////////////////////////////////////////////////////
void CResetDlg::OnEnKillfocusEdtTimeout()
{
  CString csTemp;
  GetDlgItemText(IDC_EDT_TIMEOUT, csTemp);

  TCHAR* pszEnd = NULL;
  m_ulTimeout = _tcstoul(csTemp, &pszEnd, 10);

  csTemp.Format(_T("%u"), m_ulTimeout);
  SetDlgItemText(IDC_EDT_TIMEOUT, csTemp);
}

/////////////////////////////////////////////////////////////////////////////
/// Reset Button clicked event
/////////////////////////////////////////////////////////////////////////////
void CResetDlg::OnBnClickedBtnReset()
{
  if(CcifXTestDlg::s_pcDevice)
  {
    CWaitCursor cWait;

    long lRet = CcifXTestDlg::s_pcDevice->Reset(m_ulResetMode, m_ulTimeout);

    CString csTemp;
    if(CIFX_NO_ERROR != lRet)
    {
      csTemp.Format(_T("0x%08X\r\n%s"),
                    lRet,
                    (LPCTSTR)CcifXTestDlg::s_pcDevice->GetErrorDescription(lRet));

    }
    SetDlgItemText(IDC_LASTERR, csTemp);
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Cyclic thread function (unused)
/////////////////////////////////////////////////////////////////////////////
void CResetDlg::ThreadFunction()
{
}

/////////////////////////////////////////////////////////////////////////////
/// Device Change notification (unused)
///   \param pcDevice NULL if device was closed, otherwise device has changed
/////////////////////////////////////////////////////////////////////////////
void CResetDlg::OnUpdateDevice(CCifXDeviceBase* pcDevice)
{
  bool fSysDevice = false;
  if (NULL != pcDevice)
  {
    if (pcDevice->IsSystemDevice())
      fSysDevice = true;
  }

  m_cResetModeCtrl.ResetContent();

  if (fSysDevice)
  {
    /* We only have a SYSTESTART */
    int iItem = m_cResetModeCtrl.AddString(s_atResetModes[0].szMode);
    m_cResetModeCtrl.SetItemData(iItem, s_atResetModes[0].ulMode);

  } else
  {
    /* Other channels do have both */
    for(int iIdx = 0; iIdx < sizeof(s_atResetModes) / sizeof(s_atResetModes[0]); ++iIdx)
    {
      int iItem = m_cResetModeCtrl.AddString(s_atResetModes[iIdx].szMode);
      m_cResetModeCtrl.SetItemData(iItem, s_atResetModes[iIdx].ulMode);
    }
  }

  /* Select first entry */
  m_cResetModeCtrl.SetCurSel(0);
  OnCbnSelchangeCbReset();
}
